options nocenter validvarname=any;

*---Read in space-delimited ascii file;

data new_data;


infile 'yemp-9899wdz_2005.dat' lrecl=37 missover DSD DLM=' ' print;
input
  R0000100
  S5890800
  S5890900
  S5891000
  S5891100
  S5891200
  S5891300
  S5891400
  S5891500
  S5891600
  S5891700
;
array nvarlist _numeric_;


*---Recode missing values to SAS custom system missing. See SAS
      documentation for use of MISSING option in procedures, e.g. PROC FREQ;

do over nvarlist;
  if nvarlist = -1 then nvarlist = .R;  /* Refused */
  if nvarlist = -2 then nvarlist = .D;  /* Dont know */
  if nvarlist = -3 then nvarlist = .I;  /* Invalid missing */
  if nvarlist = -4 then nvarlist = .V;  /* Valid missing */
  if nvarlist = -5 then nvarlist = .N;  /* Non-interview */
end;

  label R0000100 = "PUBID - YTH ID CODE 1997";
  label S5890800 = "IS R AN ON-CALL WORKER AT EMP L1 2005";
  label S5890900 = "IS R AN ON-CALL WORKER AT EMP L2 2005";
  label S5891000 = "IS R AN ON-CALL WORKER AT EMP L3 2005";
  label S5891100 = "IS R AN ON-CALL WORKER AT EMP L4 2005";
  label S5891200 = "IS R AN ON-CALL WORKER AT EMP L5 2005";
  label S5891300 = "IS R AN ON-CALL WORKER AT EMP L6 2005";
  label S5891400 = "IS R AN ON-CALL WORKER AT EMP L7 2005";
  label S5891500 = "IS R AN ON-CALL WORKER AT EMP L8 2005";
  label S5891600 = "IS R AN ON-CALL WORKER AT EMP L9 2005";
  label S5891700 = "IS R AN ON-CALL WORKER AT EMP L10 2005";

/*---------------------------------------------------------------------*
 *  Crosswalk for Reference number & Question name                     *
 *---------------------------------------------------------------------*
 * Uncomment and edit this RENAME statement to rename variables
 * for ease of use.  You may need to use  name literal strings
 * e.g.  'variable-name'n   to create valid SAS variable names, or 
 * alter variables similarly named across years.
 * This command does not guarantee uniqueness

 * See SAS documentation for use of name literals and use of the
 * VALIDVARNAME=ANY option.     
 *---------------------------------------------------------------------*/
  /* *start* */

* RENAME
  R0000100 = 'PUBID_1997'n
  S5890800 = 'YEMP-9899WDZ.01_2005'n
  S5890900 = 'YEMP-9899WDZ.02_2005'n
  S5891000 = 'YEMP-9899WDZ.03_2005'n
  S5891100 = 'YEMP-9899WDZ.04_2005'n
  S5891200 = 'YEMP-9899WDZ.05_2005'n
  S5891300 = 'YEMP-9899WDZ.06_2005'n
  S5891400 = 'YEMP-9899WDZ.07_2005'n
  S5891500 = 'YEMP-9899WDZ.08_2005'n
  S5891600 = 'YEMP-9899WDZ.09_2005'n
  S5891700 = 'YEMP-9899WDZ.10_2005'n
;
  /* *finish* */

run;

proc means data=new_data n mean min max;
run;


/*---------------------------------------------------------------------*
 *  FORMATTED TABULATIONS                                              *
 *---------------------------------------------------------------------*
 * You can uncomment and edit the PROC FORMAT and PROC FREQ statements 
 * provided below to obtain formatted tabulations. The tabulations 
 * should reflect codebook values.
 * 
 * Please edit the formats below reflect any renaming of the variables
 * you may have done in the first data step. 
 *---------------------------------------------------------------------*/

/*
proc format; 
value vx0f
  0='0'
  1-999='1 TO 999'
  1000-1999='1000 TO 1999'
  2000-2999='2000 TO 2999'
  3000-3999='3000 TO 3999'
  4000-4999='4000 TO 4999'
  5000-5999='5000 TO 5999'
  6000-6999='6000 TO 6999'
  7000-7999='7000 TO 7999'
  8000-8999='8000 TO 8999'
  9000-9999='9000 TO 9999'
;
value vx1f
  1='Yes'
  0='No'
;
value vx2f
  1='Yes'
  0='No'
;
value vx3f
  1='Yes'
  0='No'
;
value vx4f
  1='Yes'
  0='No'
;
value vx5f
  1='Yes'
  0='No'
;
value vx6f
  1='Yes'
  0='No'
;
value vx7f
  1='Yes'
  0='No'
;
value vx8f
  1='Yes'
  0='No'
;
value vx9f
  1='Yes'
  0='No'
;
value vx10f
  1='Yes'
  0='No'
;
*/

/* 
 *--- Tabulations using reference number variables;
proc freq data=new_data;
tables _ALL_ /MISSING;
  format R0000100 vx0f.;
  format S5890800 vx1f.;
  format S5890900 vx2f.;
  format S5891000 vx3f.;
  format S5891100 vx4f.;
  format S5891200 vx5f.;
  format S5891300 vx6f.;
  format S5891400 vx7f.;
  format S5891500 vx8f.;
  format S5891600 vx9f.;
  format S5891700 vx10f.;
run;
*/

/*
*--- Tabulations using default named variables;
proc freq data=new_data;
tables _ALL_ /MISSING;
  format 'PUBID_1997'n vx0f.;
  format 'YEMP-9899WDZ.01_2005'n vx1f.;
  format 'YEMP-9899WDZ.02_2005'n vx2f.;
  format 'YEMP-9899WDZ.03_2005'n vx3f.;
  format 'YEMP-9899WDZ.04_2005'n vx4f.;
  format 'YEMP-9899WDZ.05_2005'n vx5f.;
  format 'YEMP-9899WDZ.06_2005'n vx6f.;
  format 'YEMP-9899WDZ.07_2005'n vx7f.;
  format 'YEMP-9899WDZ.08_2005'n vx8f.;
  format 'YEMP-9899WDZ.09_2005'n vx9f.;
  format 'YEMP-9899WDZ.10_2005'n vx10f.;
run;
*/